<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class problem {
    var $error;
	/* NEW PROBLEM FIRST STEP */
	function new_problem_step_one($operation) {
		global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket=new class_ticket($database);
        $filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
        $departments=$ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        $departmentid = $departments[0]['department_id'];
       
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'problem_new_step_one.php');
        return true;
    }

    /*VIEW NEW PROBLEM FORM*/
    function new_problem($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		
		if(!isset($operation['department_id'])){
			return $this->new_problem_step_one($operation);
		}
		list($operation['domain_id'], $operation['department_id'])=explode(':', $operation['department_id']);
        $vis_department_id= $operation['department_id'];
        $domain=$operation['domain_id'];
        $vis_channel_id= $operation['channel_id'];	
		$location[0] = 2;
		
		$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['department_id']);
		$login_staff = $staff_object->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);    
		
		$filter_condtn = '(department_access=0 or find_in_set('.$vis_department_id.', department_access))';
        $impact=$ticket_module->get_properties('get_impacts', '', $filter_condtn);	
		$priorities=$ticket_module->get_properties('get_priorities', '', $filter_condtn);
		$status=$ticket_module->get_properties('get_status', '', $filter_condtn);

        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	$setting_object=new class_setting($database);
        $module_setting=$setting_object->get_module_setting('domain_id='.$operation['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		if(!isset($module_setting['vis_show_priority']) || $module_setting['vis_show_priority']==1 || $module_setting['vis_show_priority']==2){
			$module_setting['vis_priority']='';
			$priorities=$ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(!isset($module_setting['vis_show_tickettype']) || $module_setting['vis_show_tickettype']==1 || $module_setting['vis_show_tickettype']==2){
			$module_setting['vis_tickettype']='';
			$ticket_types=$ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))');
		}
		if(isset($module_setting['vis_show_level']) && ($module_setting['vis_show_level']==1 || $module_setting['vis_show_level']==2)){
			$module_setting['vis_level']='';
			list($ticket_level_count, $ticket_level_details)=$setting_object->get_ticket_level_list( $filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		}

        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'problem_new_step_two.php');
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"problem","vis_current_operations":"new_problem"});</script>';
        return true;
	}
	
	/* PROBLEM ADDED*/
	function open_new_problem($operation) {      
        global $vis_language, $operation_hnd;
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $database=new class_database();
        if(isset($operation['vis_action']))$data=parse_form_array($operation['vis_action']); else $data=$operation;
	    $problem_object=new class_problem($database);
        if(!isset($data['vis_from']) || trim($data['vis_from'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFILFRMEMAIL'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSTAFFSEMAIL'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQSUB'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_description']) || trim(strip_tags($data['vis_description'],"<img>")) == ''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFLDDESC'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$data['vis_problem_hash']=$cmdb_object->get_itil_hash($data['vis_domain'], '10', 'vis_itil_problems_prefix', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
		$staff_info=$staff->get_staff("email='".$data['vis_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff_info==-1){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGINVFLDFRMEMAIL'];
			else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSGINVFLDFRMEMAIL'].'"); </script>';
			return false;
		}
		$data['vis_from_name'] = $staff_info[0]['first_name'].' '.$staff_info[0]['last_name'];
		$data['vis_from_email'] = $staff_info[0]['email'];
		$data['vis_from']=$staff_info[0]['staff_id'];
		$ret=$problem_object->add_problem($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(VIS_LOCATION_AREA==0) {
            echo (!$ret)?'error':'success';
            return $ret;
        }
		if($ret) {
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
			$mobject=new class_mail($database);	
			$data1['problem_id'] = $ret['last_id'];
			$data1['vis_module']='itil_problem';
			$data1['send_alert'] = true;
			$ret=$mobject->email_notify($data1, 'new_problem', VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        $data['vis_problem_id']=0;
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTALL'].'/8",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"filter_problem" });</script>';	
        return true;
    }

	/*VIEW LIST*/
	function view_problems($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object=new class_problem($database);

        $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $operation['view_title']=$vis_language['TXTPROBLEMS'];
        $filter='';
		$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
		$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
        if(isset($data['vis_filter_id'])) $action[4]=$data['vis_filter_id']; 
		if(isset($operation['vis_filter_id'])) $action[4]=$operation['vis_filter_id']; 
		 
		if(isset($operation['criteria']) && $operation['criteria']!='')
		{	
			$filter.=" ( ".VIS_TABLE_PREFIX."itil_problems.problem_hash='".addslashes($operation['criteria'])."' OR ".VIS_TABLE_PREFIX."itil_problems.subject like '%".addslashes($operation['criteria'])."%') and ";
			$criteria = $operation['criteria'];
        }
		
		if($action[4]==8)
        {
			$filter.=VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and' ;
		}
		else if($action[4]==9)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_problems.status_id=1 and ';
		}
		else if($action[4]==10)
		{
			$filter.=VIS_TABLE_PREFIX.'itil_problems.status_id=3 and ';
		}
		else if($action[4]==11)
		{
			$filter.='FIND_IN_SET ("'.VIS_STAFF_ID.'", '.VIS_TABLE_PREFIX.'itil_problems.staff_id) and ';
		}
		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {
		    if($data['search_department']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_problems.department_id=".$data['search_department']." and ";
		    if($data['search_impact']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_problems.impact_id=".$data['search_impact']." and ";
		    if($data['search_priority']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_problems.priority_id=".$data['search_priority']." and ";
		    if($data['search_status']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_problems.status_id=".$data['search_status']." and ";
		}
		$filter=substr($filter, 0, -4);
		        
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($problems_info, $problems_details)=$object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count']=($problems_info['total']==0)?0:ceil($problems_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$problems_info['problems_count']=(!$problems_details || $problems_details==-1)?0:count($problems_details);
        $problems_info['page']=$page;
        // Code for api - start
		if(VIS_LOCATION_AREA==0) {
			if($problems_details!='') echo get_xml($problems_details, 'Problem');
			else echo $vis_language['MSGDATANOTFND'];
            return true;
        }
        // Code for api - end
        $database->database_disconnect();
	    if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'problems_list.php');
			$problems_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onChange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$problems_info['total'], 'paging' => $select, 'list'=> $problems_list));
		}else {
			include(VIS_PATH_TEMPLATE.'problems.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"problem","vis_current_operations":"view_problems","vis_filter_id":"'.$operation['filter_id'].'"});</script>';
		}	
        return true;
    }
	
	function delete_problem($operation) {
        global $vis_language;
        $operation['vis_current_operation']='filter_problem'; 
        $operation['vis_current_module']='problem'; 
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_problem($database);
		$sub_object=new class_subsetting($database);
        list($problems_info, $problems_details)=$object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_problem($operation['vis_problem_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_problems_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$problem_details[0]['subject']." Problem", VIS_STAFF_ID,7, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", vis_filter_id: "'.$operation['vis_filter_id'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function get_problems_delete($operation) {
        global $vis_language;
		$message_info['vis_form_title']=$vis_language['TXTDELETEPROBLEM'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
		$message_info['vis_event']="$('#vis_global_msg_div').visExecution('submit_form', {'vis_module': 'problem', 'vis_operation': 'update_properties', 'vis_action': 'delete', 'vis_form':'vis_problem_form', 'vis_update_id': 0});";
		//$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'problem', 'vis_operation':'delete_problem', 'vis_problem_id':'".$operation['vis_problem_id']."', vis_filter_id: '".$operation['vis_filter_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function problems_details($operation) {
        global $vis_language;
        $database=new class_database(); 
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        
		if(isset($operation['problem_id']) && is_numeric($operation['problem_id']) && !isset($operation['vis_problem_id'])) $operation['vis_problem_id']=$operation['problem_id'];
		if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
			$action=array('', 'problem', 'problem_details', '', $operation['vis_problem_id']);
		}
		else {
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
		}
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$action[4];
		}
		else {
			$this->error=$vis_language['MSGPRBMIDMISS'];
			return false;
		}
        
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter = " attach_type=1 AND child_id=".$problems_details[0]['problem_id'];
		list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($problems_details==-1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		$problems_details=$problems_details[0];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$sett_obj=new class_setting($database);
			
		$module_setting=$sett_obj->get_module_setting('(title="vis_show_note" or title="vis_show_custom_field") and domain_id='.$problems_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$note_details = $problem_object->get_note($problems_details['problem_id'], 3, 6, $problems_details['problem_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $staff_info=$staff_object->get_staff("staff_id='".$problems_details['problem_from']."'", VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($problems_details['attachment_id']!=''){ 
			$attachments=$problem_object->get_problem_attachment($problems_details['attachment_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		
		include(VIS_PATH_TEMPLATE.'problem_view.php');
		echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"problem","vis_current_operations":"problems_details"});</script>';
		
        return true;
    }
	
	function get_details($operation) {
        global $vis_language;
		switch($operation['vis_action']) {
            case 'details':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					$filter = " attach_type=4 AND parent_id=".$problems_details['problem_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=1 AND child_id=".$problems_details['problem_id'];
					list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=2 AND parent_id=".$problems_details['problem_id'];
					list($total_change, $attached_change)=$problem_object->get_changes_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter = " attach_type=8 AND parent_id=".$problems_details['problem_id'];
					list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.department_id='.$problems_details['department_id'].' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$problems_details['domain_id'].' and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
				    $departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        			$owner_details=-1;
                    if($problems_details['staff_id']!='' && $problems_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($problems_details['staff_id']);
					}
                    
                   include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	           $setting_object=new class_setting($database);
                   $module_setting=$setting_object->get_module_setting('domain_id='.$problems_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
                   $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['department_id'].', department_access))';
		   if(isset($module_setting['vis_show_category']) && ($module_setting['vis_show_category']==1 || $module_setting['vis_show_category']==2)){
			$module_setting['vis_category']='';
			list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		}
		if(VIS_ITIL==1){
			$location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['department_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
		}

                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_details.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
            case 'audit_log':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $object=new class_ticket($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');  
                    $staff=new class_staff($database);
					list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
                    $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;     
					$limit=($page*$view_info['page_count']).','.$view_info['page_count'];	
                    list($audit_log_info, $audit_log)=$object->audit_log($operation['vis_problem_id'], $limit, $page, VIS_STAFF_ID, VIS_LOCATION_AREA, 1);
                    $view_info['page_count']=($audit_log_info['total']==0)?0:ceil($audit_log_info['total']/$view_info['page_count']);
					$audit_log_info['page']=$page;
					$view_info['view_count']=count($view_details);
                    $audit_count=($audit_log==-1)?0:count($audit_log);
                    for($i=0 ; $i<$audit_count ; $i++)
                    {
						switch($audit_log[$i]['operation_id']) {
							case '0':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
								$audit_log[$i]['audit_log_operation']=$vis_language['MSGNEWPROBLEM'].' by '.$staff_name;
								
								break;
								
							case '1':
								
									include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
									$object=new class_setting($database);
									$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
									$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTRPLD'].' by '.$staff_name;
								
								break;
							
							case '2':
								$audit_log[$i]['audit_log_operation'] = 'Status updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '3':
								$audit_log[$i]['audit_log_operation'] = 'Priority updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '4':
								$audit_log[$i]['audit_log_operation'] = 'Department updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '5':
								$audit_log[$i]['audit_log_operation'] = 'Impact updated from '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
								break;
								
							case '6':
								$audit_log[$i]['audit_log_operation'] = 'Problem properties updated';
								break;
								
							case '7':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_new_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['new_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$new_info =  $staff_new_info[1][0]['first_name'].' '.$staff_new_info[1][0]['last_name'];
								if($audit_log[$i]['new_info']!=0 && $staff_new_info[1]!=-1)
									$audit_log[$i]['audit_log_operation'] = 'Problem assigned to '. $new_info;
								elseif($audit_log[$i]['new_info']==0 && $audit_log[$i]['old_info']>0){ 
									$staff_old_info=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['old_info'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
									$old_info =  $staff_old_info[1][0]['first_name'].' '.$staff_old_info[1][0]['last_name'];
									$audit_log[$i]['audit_log_operation'] = 'Problem unassigned From '. $old_info;
								}
								else
									$audit_log[$i]['audit_log_operation'] = 'Problem assigned to Nobody';
								break;
								
							case '8':
								include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
								$object=new class_setting($database);
								$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['operator_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
								$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
								$audit_log[$i]['audit_log_operation']=$vis_language['MSGTKTTRSH'] .' by '.$staff_name;
								break;
								
							case '9':
								$audit_log[$i]['audit_log_operation'] = 'Problem description updated';
								break;
							

							case '10':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis rootcause updated';
								break;
							

							case '11':
								$audit_log[$i]['audit_log_operation'] = 'Link new permanent solution '. $audit_log[$i]['old_info']. ' to problem';
								break;
							

							case '12':
								$audit_log[$i]['audit_log_operation'] = 'Link new workaround solution '. $audit_log[$i]['old_info']. ' to problem';
								break;
							
							case '13':
								$audit_log[$i]['audit_log_operation'] = 'Detach permanent solution '. $audit_log[$i]['old_info'];
								break;
							

							case '14':
								$audit_log[$i]['audit_log_operation'] = 'Detach workaround solution '. $audit_log[$i]['old_info'];
								break;
															
							case '15':
								$audit_log[$i]['audit_log_operation'] = 'Linked ticket '. $audit_log[$i]['old_info'];
								break;
															
							case '16':
								$audit_log[$i]['audit_log_operation'] = 'Linked CI '. $audit_log[$i]['old_info'];
								break;
															
							case '17':
								$audit_log[$i]['audit_log_operation'] = 'Linked changes '. $audit_log[$i]['old_info'];
								break;
							
							case '18':
								$audit_log[$i]['audit_log_operation'] = 'Linked task '. $audit_log[$i]['old_info'];
								break;
								
							case '19':
								$audit_log[$i]['audit_log_operation'] = 'Detach ticket '. $audit_log[$i]['old_info'];
								break;
															
							case '20':
								$audit_log[$i]['audit_log_operation'] = 'Detach CI '. $audit_log[$i]['old_info'];
								break;
															
							case '21':
								$audit_log[$i]['audit_log_operation'] = 'Detach changes '. $audit_log[$i]['old_info'];
								break;
							
							case '22':
								$audit_log[$i]['audit_log_operation'] = 'Detach task '. $audit_log[$i]['old_info'];
								break;
														
							case '23':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis impact updated';
								break;
								
							case '24':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis symptoms updated';
								break;
							
							case '25':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis rootcause deleted';
								break;
							
							case '26':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis impact deleted';
								break;
							
							case '27':
								$audit_log[$i]['audit_log_operation'] = 'Problem analysis symptoms deleted';
								break;
                                                        case '46':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '47':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETSUBCATEGORYCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '48':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGTICKETITEMCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;
								case '49':
									$audit_log[$i]['audit_log_operation']=$vis_language['MSGITILLOCATIONCHANGED'].' '. $audit_log[$i]['old_info']. ' to '. $audit_log[$i]['new_info'];
									break;

						}
					}
                    $database->database_disconnect();
                    if(VIS_LOCATION_AREA==0) {
                        echo get_xml($audit_log, 'audit_log');
                        return true;
                    }
                    else {
                        include_once(VIS_PATH_TEMPLATE.'problem_audit_log.php');
                        return true;
                    }
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'notes':
				if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
					$sett_obj=new class_setting($database);
                    $module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$operation['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
					$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($operation['vis_problem_id'], 3,6, $operation['vis_client_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
					include(VIS_PATH_TEMPLATE."problem_note_details.php");
					return true;
				}
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'analysis':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'");</script>';
                        return false;
                    }
					$problems_details=$problems_details[0];$attachments=-1;
					if($operation['vis_analysis_type']=='rootcause'){
						if($problems_details['rootcause_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($problems_details['rootcause_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					if($operation['vis_analysis_type']=='impact'){
						if($problems_details['impact_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($problems_details['impact_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					if($operation['vis_analysis_type']=='symptons'){
						if($problems_details['symptoms_attachment']!=''){ 
							$attachments=$problem_object->get_problem_attachment($problems_details['symptoms_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
						}
					}
					$database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_analysis_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            case 'solution':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'selfhelp.php');
					$selfhelp_object=new class_selfhelp($database);
					$workaround_data = $permanent_data = -1;
					if($problems_details['permanent_id']!=''){	
						$filter='article_id='.$problems_details['permanent_id'];
						list($categories_info, $permanent_data)=$selfhelp_object->get_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
					if($problems_details['workaround_id']!=''){		
						$filter='article_id='.$problems_details['workaround_id'];
						list($categories_info, $workaround_data)=$selfhelp_object->get_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					}					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_solution_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            case 'analysis_solution':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
                    $ticket_object=new class_ticket($database);
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
                    if(VIS_LOCATION_AREA==0) {
                        echo get_xml($ticket_details, 'ticket');
                        return true;
                    }
                    else {
                        $view_info['page_count']=($ticket_info['total']==0)?0:ceil($ticket_info['total']/$view_info['page_count']);
                        $ticket_info['ticket_count']=(!$ticket_details || $ticket_details==-1)?0:count($ticket_details);
                        if($operation['vis_ticket']==1)
                        $ticket_info['page']=$page;
                        else
                        $ticket_info['page']=$page*$view_info['page_count'];
                        $view_info['view_count']=count($view_details);
                        if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) $ticket_id=$operation['vis_problem_id'];
                        else $ticket_id=0;
                        foreach($view_details as $v){
							if($ticket_details!=-1){			
								for($i=0;$i<count($ticket_details);$i++){
									switch($v['tab_name']){
										case 'link': 	
											$link_data=array('vis_problem_id'=>$ticket_details[$i]['ticket_id'], 'case'=>1);	
											$link = $ticket_object->get_ticket_link($link_data, VIS_STAFF_ID, VIS_LOCATION_AREA);
											$ticket_details[$i]['link_present']=($link == -1)?0:1;
											break;
										case 'label':	
											$label_details[$i] = $ticket_object->get_ticket_labels($ticket_details[$i]['ticket_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
											break;
										default: // this case will execute at last
											$ticket_lock[$i] = $ticket_object->get_ticket_lock($ticket_details[$i]['ticket_id'], 'staff_id!='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
									}
								}
							}
						}
                        include_once(VIS_PATH_TEMPLATE.'problems_list.php');
                    }
					$problems_details=$problems_details[0];
					                                                
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'new_analysis_solution.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_ci':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					$filter = " attach_type=4 AND parent_id=".$problems_details['problem_id'];
					list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);                                              
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_attach_ci_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_ticket':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					$filter = " attach_type=1 AND child_id=".$problems_details['problem_id'];
					list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);                                              
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_attached_ticket_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_changes':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					$filter = " attach_type=2 AND parent_id=".$problems_details['problem_id'];
					list($total_changes, $attached_changes)=$problem_object->get_changes_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_attached_changes_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
			case 'attach_task':
                if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
                    $database=new class_database();
                    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
                    $problem_object=new class_problem($database);
                    $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($problems_details==-1) {
                        echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBNTACC'].'"); $(this).visInterface("remove_tab", "vis_module_ticket_div"); </script>';
                        return false;
                    }
					$problems_details=$problems_details[0];
					$filter = " attach_type=8 AND ".VIS_TABLE_PREFIX."itil_relation.parent_id=".$problems_details['problem_id'];
					list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
                    $database->database_disconnect();
                    include_once(VIS_PATH_TEMPLATE.'problem_attached_task_list.php');
                    return true;
                }
                else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRBMIDMISS'].'"); </script>';
                    return false;
                }
            break;
        }
        if(VIS_LOCATION_AREA==2) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVOPT'].' '.$operation['vis_action'].'"); </script>';
        else echo 'error';
        return false;
    }

	function show_user_details($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        if(isset($operation['vis_post_id']) && $operation['vis_post_id']!=""){
            $user_details=$ticket_object->get_user_details($operation['vis_post_id'], $operation['vis_submitter'], $operation['vis_submitter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        } else if($operation['vis_submitter']==1){
             include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
            $client_object=new class_client($database);
            $user_details=$client_object->get_client(VIS_TABLE_PREFIX.'client.client_id='.$operation['vis_submitter_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $user_details=$user_details[1][0];
        } else {
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
            $staff_object=new class_staff($database);
            $user_details=$staff_object->get_staff('staff_id='.$operation['vis_submitter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $user_details=$user_details[0];
			$staff_gr_details = $staff_object->get_staff_group('group_id ='.$user_details['group_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$user_details['group_name'] = $staff_gr_details[0]['group_name'];
        }
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $sett_obj=new class_setting($database);		       
		$module_setting=$sett_obj->get_module_setting('domain_id='.$user_details['domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($operation['vis_task_id']) && $operation['vis_task_id']!=""){
			$details_txt='<div class="form-group"><div class="col-sm-12"><label>'.$vis_language['TXTNAME'].'</label><span class="link m-l-sm">'.$user_details['first_name'].' '.$user_details['last_name'].'</span></div></div>';
			$details_txt.='<div class="form-group"><div class="col-sm-12"><label>'.$vis_language['TXTEMAIL'].'</label><span class="link m-l-sm">'.$user_details['email'].'</span></div></div>';
			$details_txt.='<div class="form-group"><div class="col-sm-12"><label>'.$vis_language['TXTCONTACTNUMBER'].'</label><span class="link m-l-sm">'.$user_details['contact_number'].'</span></div></div>';
		}
		else
		{
			$details_txt='<div class="form-group"><div class="col-sm-12"><label>'.$vis_language['TXTEMAIL'].'</label><span class="link m-l-sm">'.$user_details['email'].'</span></div></div>';
			if (isset($module_setting['vis_show_ip_addr']) && $module_setting['vis_show_ip_addr'] === 1 && isset($operation['vis_post_id']) && $operation['vis_post_id']!="") {
				$details_txt.='<div class="form-group"><div class="col-sm-12 m-t-xs"><label>' . $vis_language['TXTIPADDRESS'] . '</label><span class="link m-l-sm">' . $user_details['ipaddress'] . '</span></div></div>';
			}
			 if ($user_details['parent_name'] == "") {
				$details_txt.='<div class="form-group"><div class="col-sm-12 m-t-xs"><label>'.(($operation['vis_submitter']!=1) ? $vis_language['TXTTEAM'] : $vis_language['TXTORGANIZATION']).'</label><span class="link m-l-sm">'.$user_details['group_name'].'</span></div></div>';
			}
			$details_txt.='<div class="form-group"><div class="col-sm-12 m-t-xs"><label>'.$vis_language['TXTCONTACTNUMBER'].'</label><span class="link m-l-sm">'.$user_details['contact_number'].'</span></div></div>';
			if ($user_details['parent_name'] != "") {
				$details_txt.='<div class="form-group"><div class="col-sm-12 m-t-xs"><label>'.$vis_language['TXTPARENT'].'</label><span class="link m-l-sm">'.$user_details['parent_name'].'</span><span class="link m-l-xs">< '.$user_details['parent_email'].' ></span></div></div>';
			}
		}
        echo $details_txt;
    }
	
	function load_lists($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $release_object=new class_releases($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        switch($operation['vis_action']) {
            case 'department':
                if(defined('VIS_ANY_DEPT') && VIS_ANY_DEPT==1)
                    $dept_list = $ticket_object->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'],VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
                else $dept_list = $ticket_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'],VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
                $txt = $domain_id = $return_value = $select_dept_txt =''; 
				for($i=0;$i<count($dept_list);$i++) {
					$selected ='';
					if($domain_id=="" || ($domain_id != "" && $domain_id != $dept_list[$i]['domain_id'])){
						$domain_id = $dept_list[$i]['domain_id'];
						if($i!=0) $return_value .= '</optgroup>';
					}
					if($operation['vis_selected_id']==$dept_list[$i]['department_id']){
						$selected = "selected='selected'";
						$select_dept_txt = $dept_list[$i]['domain_name'] .' : '. $dept_list[$i]['department_name'];
					}
					$txt = $dept_list[$i]['domain_name']. ' : '. $dept_list[$i]['department_name'];
					$return_value .= '<option value="'.$dept_list[$i]['department_id'].'" '.$selected.'>'.$txt.'</option>';
				}	
				echo '<select id="departmentlist" name="department" class="selectpicker" data-selector-label="'.$select_dept_txt.'" onchange="update_properties(this.value,1);"'.((count($dept_list)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
			case 'startdate':
  				echo '<input type="text" name="vis_startdate" id="vis_startdate" onfocusout="reset_dates(\'startdate\');" onchange="update_properties(this.value,6);" class="form-control from_date" value="'.date(VIS_EDITDATETIMEPICKER_FORMAT,format_timezone($operation['vis_selected_id'])).'"><script>$(".from_date").datetimepicker({format: "'.VIS_DATETIMEPICKER_FORMAT.'"});$("#vis_startdate").focus();</script>';				
			break;
			case 'enddate':
				echo '<input type="text" name="vis_enddate" id="vis_enddate" onfocusout="reset_dates(\'enddate\');" onchange="update_properties(this.value,7);" class="form-control from_date" value="'.date(VIS_EDITDATETIMEPICKER_FORMAT,format_timezone($operation['vis_selected_id'])).'"><script>$(".from_date").datetimepicker({format: "'.VIS_DATETIMEPICKER_FORMAT.'",});$("#vis_enddate").focus();</script>';				
			break;
            case 'status':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                $status_list = $ticket_object->get_status_list($filter_condtn, VIS_STAFF_ID, VIS_LOCATION_AREA);
                $select_txt=$return_value='';
                foreach($status_list as $status){ 
					$return_value.='<option style="color:'.$status['color'].';" '.(($status['status_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$status['status_id'].'">'.$status['status_name'].'</option>';
                    if($status['status_id']==$operation['vis_selected_id']) $select_txt = $status['status_name'];
				} 
				echo '<select id="statuslist" name="status" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,2);"'.((count($status_list)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
            case 'priority':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                $priority_list = $ticket_object->get_priorities_list($userid, VIS_LOCATION_AREA, $filter_condtn);
                $select_txt=$return_value='';
                foreach($priority_list as $priority){ 
					$return_value.='<option  style="color:'.$priority['color'].';" '.(($priority['priority_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$priority['priority_id'].'">'.$priority['priority_name'].'</option>';
                    if($priority['priority_id']==$operation['vis_selected_id']) $select_txt = $priority['priority_name'];
				} 
				echo '<select id="prioritylist" name="priority" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,3);"'.((count($priority_list)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
            case 'impact':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                list($impact_info, $impact)=$setting_object->get_impact($filter_condtn, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $select_txt=$return_value='';
				if($impact!=-1) foreach($impact as $type){ 
					$return_value.='<option style="color:'.$type['color'].';" '.(($type['impact_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['impact_id'].'">'.$type['name'].'</option>';
                    if($type['impact_id']==$operation['vis_selected_id']) $select_txt = $type['name'];
				} 
				echo '<select id="impactlist" name="impact" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,4);"'.((count($impact)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;

			case 'risk':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                list($risk_info, $risk)=$setting_object->get_risk($filter_condtn, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $select_txt=$return_value='';
				foreach($risk as $type){ 
					$return_value.='<option  style="color:'.$type['color'].';" '.(($type['risk_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['risk_id'].'">'.$type['name'].'</option>';
                    if($type['risk_id']==$operation['vis_selected_id']) $select_txt = $type['name'];
				} 
				echo '<select id="risklist" name="risk" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,9);"'.((count($risk)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
			
			case 'change_type':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                list($change_type_info, $change_type_details)=$setting_object->get_change_type($filter_condtn, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $select_txt=$return_value='';
				foreach($change_type_details as $type){ 
					$return_value.='<option  style="color:'.$type['color'].';" '.(($type['change_type_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['change_type_id'].'">'.$type['name'].'</option>';
                    if($type['change_type_id']==$operation['vis_selected_id']) $select_txt = $type['name'];
				} 
				echo '<select id="change_type_list" name="change_type_list" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,10);"'.((count($change_type_details)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;

			case 'releasetype':
                $filter_condtn = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
                list($release_type_info, $release_type_details)=$setting_object->get_release_type($filter_condtn, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $select_txt=$return_value='';
				foreach($release_type_details as $type){ 
					$return_value.='<option  style="color:'.$type['color'].';" '.(($type['release_type_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['release_type_id'].'">'.$type['name'].'</option>';
                    if($type['release_type_id']==$operation['vis_selected_id']) $select_txt = $type['name'];
				} 
				echo '<select id="releasetypelist" name="release_type" class="selectpicker" data-selector-label="'.$select_txt.'" onChange="update_properties(this.value,9);"'.((count($release_type_details)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
			case 'release_owner':
					$filter=VIS_TABLE_PREFIX.'itil_releases.release_id='.$operation['vis_release_id'];
					list($releases_info, $releases_details)=$release_object->get_releases($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
					$releases_details=$releases_details[0];
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
					$staff_object=new class_staff($database);
        			$owner_details=-1;
                    if($releases_details['staff_id']!='' && $releases_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($releases_details['staff_id']);
					}
					$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['vis_dept_id']);
					$flag='owner';
					include_once(VIS_PATH_TEMPLATE.'problem_changes_properties.php');
            break;

            case 'owner':
					$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
					list($problems_info, $problems_details)=$problem_object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					$problems_details=$problems_details[0];
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
					$staff_object=new class_staff($database);
        			$owner_details=-1;
                    if($problems_details['staff_id']!='' && $problems_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($problems_details['staff_id']);
					}              
                
					$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['vis_dept_id']);
					$flag='owner';
					include_once(VIS_PATH_TEMPLATE.'problem_changes_properties.php');
            break;
			case 'change_owner':
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
					$changes_object=new class_changes($database);
					$filter=VIS_TABLE_PREFIX.'itil_changes.changes_id='.$operation['vis_changes_id'];
					list($changes_info, $changes_details)=$changes_object->get_changes($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
					$changes_details=$changes_details[0];
					include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
					$staff_object=new class_staff($database);
        			$owner_details=-1;
                    if($changes_details['staff_id']!='' && $changes_details['staff_id']!='0'){
						$owner_details=$problem_object->get_problem_owner($changes_details['staff_id']);
					}              
                
					$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['vis_dept_id']);
					$flag='owner';
					include_once(VIS_PATH_TEMPLATE.'problem_changes_properties.php');
            break;
            case 'category':
                $filter = 'is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_dept_id'].', department_access))';
		list($ticket_cat_count,$ticket_cat_details)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
                $select_txt=$return_value='';
                $return_value.='<option value="0">'.$vis_language['TXTSELECT'].'</option>';
                if($operation['vis_selected_id']==0) $select_txt = $vis_language['TXTSELECT'];
				if($ticket_cat_details!=-1) foreach($ticket_cat_details as $type){ 
					$return_value.='<option '.(($type['category_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['category_id'].'">'.$type['title'].'</option>';
                    if($type['category_id']==$operation['vis_selected_id']) $select_txt = $type['title'];
				} 
				echo '<select id="categorylist" name="category" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,15);"'.((count($ticket_cat_details)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
            break;
            case 'subcategory':
                $filter_condtn = ($operation['vis_category_id'] == 0) ? VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1 and '.VIS_TABLE_PREFIX.'ticket_subcategory.category_id=0' : VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1 and '.VIS_TABLE_PREFIX.'ticket_subcategory.category_id='.$operation['vis_category_id'];
		list($cat_count,$subcategory_list)=$setting_object->get_ticket_subcategory_list($filter_condtn,'', VIS_STAFF_ID, VIS_LOCATION_AREA,"");
                $select_txt=$return_value='';
                $return_value.='<option value="0">'.$vis_language['TXTSELECT'].'</option>';
                if($operation['vis_selected_id']==0) $select_txt = $vis_language['TXTSELECT'];
				if($subcategory_list!=-1) foreach($subcategory_list as $type){ 
					$return_value.='<option '.(($type['subcategory_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['subcategory_id'].'">'.$type['title'].'</option>';
                    if($type['subcategory_id']==$operation['vis_selected_id']) $select_txt = $type['title'];
				} 
				echo '<select id="subcategorylist" name="subcategory" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,16);"'.((count($subcategory_list)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
          break;
          case 'item':
                $filter_condtn = ($operation['vis_subcategory_id'] == 0) ? VIS_TABLE_PREFIX.'ticket_item.is_enabled=1 and '.VIS_TABLE_PREFIX.'ticket_item.subcategory_id=0' : VIS_TABLE_PREFIX.'ticket_item.is_enabled=1 and '.VIS_TABLE_PREFIX.'ticket_item.subcategory_id='.$operation['vis_subcategory_id'];
		list($cat_count,$item_list)=$setting_object-> get_ticket_item_list($filter_condtn,'', VIS_STAFF_ID, VIS_LOCATION_AREA,"");
                $select_txt=$return_value='';
                $return_value.='<option value="0">'.$vis_language['TXTSELECT'].'</option>';
                if($operation['vis_selected_id']==0) $select_txt = $vis_language['TXTSELECT'];
				if($item_list!=-1) foreach($item_list as $type){ 
					$return_value.='<option '.(($type['item_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$type['item_id'].'">'.$type['title'].'</option>';
                    if($type['item_id']==$operation['vis_selected_id']) $select_txt = $type['title'];
				} 
				echo '<select id="itemlist" name="item" class="selectpicker" data-selector-label="'.$select_txt.'" onchange="update_properties(this.value,17);"'.((count($item_list)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
          break;
          case 'location':
                $location_assets=$setting_object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$operation['vis_dept_id'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)",0, -1, '', VIS_STAFF_ID);
                $select_txt=$return_value='';
				if($location_assets!= -1){ //for ($i = 0; $i < count($location_assets); $i++){ 
					//$return_value.='<option '.(($location_assets[$i]['location_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$location_assets[$i]['location_id'].'">'.$location_assets[$i]['name'].'</option>';
                    //if($location_assets[$i]['location_id']==$operation['vis_selected_id']) $select_txt = $location_assets[$i]['name'];
				function vis_show_subcategories($location_assets,$call=NULL,$operation) {
					global $vis_language;
					if($call==NULL || $call==''){
						$return_value ='<option value="0">'.$vis_language['TXTSELECT'].'</option>';
						if($operation['vis_selected_id']==0) $select_txt = $vis_language['TXTSELECT'];
					}
         		    foreach($location_assets as $location){ 
						$return_value.='<option '.(($location['location_id']==$operation['vis_selected_id'])?'selected="selected"':"").' value="'.$location['location_id'].'">'.$location['name'].'</option>';
							if($location['location_id']==$operation['vis_selected_id']) $select_txt = $location['name'];
							if(isset($location['subcat']) && $location['subcat']!=NULL) { 
								 $return_value.= vis_show_subcategories($location['subcat'],'sub_cat',$operation); 
							}
					}
					echo '<script>$("#assets_location").attr("data-selector-label","'.$select_txt.'");</script>';
					return $return_value;
				}
				$return_value= vis_show_subcategories($location_assets,'',$operation);
				} 
				echo '<select id="locationlist" name="location" class="selectpicker" onchange="update_properties(this.value,18);"'.((count($location_assets)>10)?' data-live-search="true"':'').'>'.$return_value.'</select>';
          break; 
        }
        return true;
    }
    
	function update_properties($operation) {
        global $vis_language;
        $list_chk=array();
		$database=new class_database();
        global $operation_hnd;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
        if(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id'])) {
            $property=$operation['vis_action'];
            $list_chk[]=$operation['vis_problem_id'];
            $area=0;
        } else {
            $options=parse_form_array($operation['vis_action']);
            $property=$options['action'];
            $operation['vis_action']=$property;
            foreach($options as $data=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $data)) $list_chk[]=$value;
            $area=1;
        }
		if(isset($operation['dept']) && $operation['dept']!=''){
            $department_list=array();
            for($i=0;$i<count($operation['dept']);$i++){
                $temp=explode('-',$operation['dept'][$i]);
                $department_list[$i]=$temp[0];
            }
        }
		
        if(empty($list_chk)){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		if($property=='link' && (count($list_chk)<2)){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSELECTMULTIPLEPROBLMESTOLINK'].'");</script>';
            return false;
        }
        if(isset($operation['vis_update_id']) && is_numeric($operation['vis_update_id'])) {
			if($property=='priority')
			{
				 $filter='is_enabled=1 and priority_id='.$operation['vis_update_id'];
				 $priority_department=$ticket_object->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
				 $priority_dept_access=explode(',', $priority_department[0]['department_access']);
				 if($priority_department[0]['department_access']!=0)
				 {
					for($k=0;$k<count($department_list);$k++){
						if(!in_array($department_list[$k], $priority_dept_access)) {
							unset($list_chk[$k]);
						}
					}
				 }
			}
			if($property=='status')
			{
				 $filter='is_enabled=1 and status_id='.$operation['vis_update_id'];
				 $status_department=$ticket_object->get_status_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $status_dept_access=explode(',', $status_department[0]['department_access']);
				 if($status_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $status_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			if($property=='impact')
			{
				 $filter='is_enabled=1 and impact_id='.$operation['vis_update_id'];
				 list($impact_info, $impact_department)=$setting_object->get_impact($filter, '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
				 $impact_dept_access=explode(',', $impact_department[0]['department_access']);
				 if($impact_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $impact_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
                        if($property=='category')
			{
				 $filter='is_enabled=1 and category_id='.$operation['vis_update_id'];
				 list($category_info, $category_department)=$setting_object->get_ticket_category_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA,"");
				 $category_dept_access=explode(',', $category_department[0]['department_access']);
				 if($category_department[0]['department_access']!=0)
				 {
					 for($k=0;$k<count($department_list);$k++){
						 if(!in_array($department_list[$k], $category_dept_access)) {
							 unset($list_chk[$k]);
						 }
					}	
				 }
			}
			
            $ret=$problem_object->set_problem_property($property, $operation, $list_chk, VIS_STAFF_ID, VIS_LOCATION_AREA);
            for($i=0;$i<count($list_chk);$i++) {
                $operation['vis_problem_id']=$list_chk[$i];
            }
            $database->database_disconnect();
			
			if(VIS_LOCATION_AREA==0) {
                echo ($ret)?'success':'error';
            }
            else {
               if(!$ret && $property=='link'){
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("[id^=\'vis_global_mass_chk_\']").attr("checked",false); </script>';
                }
                else if(!$ret) {
                    $msg = ($property == 'department') ? $vis_language['MSGPROBLEMMOVETODEPT'] : $vis_language['MSGACCSSDND'];
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");$("[id^=\'vis_global_mass_chk_\']").attr("checked",false); </script>';
                    return false;
                } else {
					echo '<script>';
                    if($area==0) {
                        if($property=='delete' || $property=='spam')
                            echo "$('#vis_workpanel_div').visExecution('load_module', '".$vis_language['TXTPROBLEMS']."', {'vis_module':'problem', 'vis_operation':'filter_problem', 'vis_filter_id': 8});";
                        else {
                            echo ' $("#vis_details_list_'.$operation['vis_problem_id'].'").visExecution("load_area",{"vis_module":"problem", "vis_operation":"get_details", "vis_action":"details", "vis_problem_id":'.$operation['vis_problem_id'].'});';
                        } 
                    }
                    else{
						if($options['vis_export_function'] == '3')
							echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'problem', 'vis_operation':'filter_problem', 'vis_filter_id': '".$options['vis_filter_id']."'});";
						else if($options['vis_export_function'] == 'filter_queue_problems'){
							if(isset($options['vis_filter_id']) && strstr($options['vis_filter_id'], '-')) {
								$info=explode('-', $options['vis_filter_id']);
								echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'problem', 'vis_operation':'filter_queue_problems', 'vis_department_id':".$info[1].", 'vis_status_id':".$info[0]."});";
							}
							else 
								echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'problem', 'vis_operation':'filter_problem', 'vis_filter_id': '".$options['vis_filter_id']."'});";
						}
						else echo "$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'problem', 'vis_operation':'filter_problem', 'vis_filter_id': '".$options['vis_filter_id']."','vis_tag':'tag'});";
					}
                    if($options['vis_export_function'] == 'filter_queue_problems' || $options['vis_export_function'] == 'view_problems') { 
						
					}echo '$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");'; 
                    echo '</script>';
                }
            }
            return $ret;
        }
        else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
    }
	
	function filter_problem($operation) {
		
		if(isset($operation['vis_filter_id']) && is_numeric($operation['vis_filter_id'])) $filter_id=$operation['vis_filter_id']; 
        else if(isset($operation['vis_action']) && $operation['vis_action'] != ""){
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			$operation['filter_id']= (isset($action[4]))?$action[4]:$operation['vis_filter_id'];
			
            if(isset($action[4]) && is_numeric($action[4])) {
                $operation['vis_filter_id'] = $filter_id=$action[4];
			}
        }
        else $filter_id=8;
		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);   
        if(isset($operation['vis_page']) && is_numeric($operation['vis_page'])) {
            $page=$operation['vis_page'];
            if(isset($_COOKIE['vis_filter_id_page'])) $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
            $vis_filter_id_page[$filter_id]=$page;
            setcookie('vis_filter_id_page', serialize($vis_filter_id_page));
        } else {
            $page=0;
            if(isset($_COOKIE['vis_filter_id_page'])) {
                $vis_filter_id_page=unserialize($_COOKIE['vis_filter_id_page']);
                if(isset($vis_filter_id_page[$filter_id]) && is_numeric($vis_filter_id_page[$filter_id])) $page=$vis_filter_id_page[$filter_id];
            }
        }
		
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $filter=$problem_object->get_filter($filter_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($filter_id==8) $filter['filter'].= ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3';
        if($filter != ""){
			if(!isset($operation['view_title']))
            $operation['view_title']=$filter['filter_name'];
            $operation['filter_id']=$filter['filter_id'];
        } else {
            $operation['vis_filter_id'] = 1;
            return $this->filter_problem($operation);
        }
        $database->database_disconnect();
		
		
         if($filter['filter_name']=="Search Result")
			return $this->problem_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else if($filter['filter_name']!="Search Result" && $filter['filter_name']!="Problems" )
			return $this->problem_display($operation, '', '', $filter['filter'], $page, $sort_by);
        else 
			return $this->problem_display($operation, '', '', $filter['filter'], $page, $sort_by);
    }
	
	function problem_display($operation, $and_conditions, $or_conditions, $filter='', $page=0, $sort_by='') {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object=new class_problem($database);
        if(isset($operation['vis_filter_array']) && $operation['vis_filter_array']!='')
        {
			$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id in ('.$operation['vis_filter_array'].')';
		}
		
		$quick_view=$object->get_problem_filter_counts('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        list($problems_info, $problems_details)=$object->get_problems($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count']=($problems_info['total']==0)?0:ceil($problems_info['total']/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
		$view_info['view_title']=$operation['view_title'];
		$problems_info['problems_count']=(!$problems_details || $problems_details==-1)?0:count($problems_details);
        $problems_info['page']=$page;
		
		
		if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1) || (isset($operation['vis_action']) && $operation['vis_action']=='no_load')){
			ob_start();
			include(VIS_PATH_TEMPLATE.'problems_list.php');
			$problems_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select = "<select name=\"pageing\" class=\"form-control input-sm selectpicker pull-right paging v-middle\" onchange=\"vis_apply_filter(this.value, '".$operation['vis_filter_id']."');\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$problems_info['problems_count'], 'paging' => $select, 'list'=> $problems_list, 'filter_id'=>$operation['vis_filter_id']));
		}else{
			//--filter list data
			if(isset($operation['vis_action'])) $options=parse_form_array($operation['vis_action']);
			else $options=$operation;
	
			include(VIS_PATH_TEMPLATE.'problems.php');
			echo '<script>$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"problem","vis_current_operations":"filter_problem","vis_filter_id":"'.$operation['filter_id'].'"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function new_note($operation){
        $message_info['problem_id']=(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id']))?$operation['vis_problem_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'problem_note.php');
		return true;
    }

    function add_note($operation) {
        global $vis_language, $operation_hnd;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_note'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");</script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $data['vis_note']=nl2br($data['vis_note']);
		$data['vis_id'] = $data['vis_problem_id'];
        $result = $problem_object->add_note($data,3,6, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $data=array_merge($data, $operation);
        if(VIS_LOCATION_AREA==0) {
            echo ($result)?'success':'error';
        }
        else {
            if($result){
			    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                $sett_obj=new class_setting($database);
                if(VIS_GAMIFICATION_ACCESS == 1) 
                {
                     include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
                     $staff=new class_staff($database);
                     $staff_info=$staff->get_staff('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
                     $points = $sett_obj->calculate_points($staff_info[0],7,IS_STAFF_ID,VIS_LOCATION_AREA); 
                }
				$module_setting=$sett_obj->get_module_setting('title="vis_show_note" and domain_id='.$data['vis_domain_id'].' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA); 
				$note_details=(VIS_NOTE_ACCESS==0)?-1:$problem_object->get_note($data['vis_problem_id'], 3,6, $data['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("toggle");';
				$active_tab="notes";
				echo '$("#vis_details_list_'.$data['vis_problem_id'].'").visExecution("load_area", {"vis_module":"problem", "vis_operation":"get_details", "vis_action":"notes", "vis_problem_id":'.$data['vis_problem_id'].',"vis_client_id":'.$data['vis_staff_id'].',"vis_domain_id":'.$data['vis_domain_id'].'});';
				echo 'set_active_tab("notes");</script>';
            }
            else{
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
            }
        }
        return $result;
        $database->database_disconnect();
    }

	function get_problem_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		$filter = VIS_TABLE_PREFIX.'itil_problems.domain_id='.$operation['vis_domain_id'].' AND ';
		
        if(isset($operation['vis_filter_enable'])){
			$filter .= VIS_TABLE_PREFIX."itil_problems.subject like '%".addslashes($operation['vis_filter'])."%' AND ";
		}
		$filter=substr($filter, 0, -4);
		if(VIS_PROBLEM_VIEW_ACCESS==0)
		{
			echo json_encode(array('vis_msg' => $vis_language['MSGACCSSDND']));
			return false;
		}
		
	    list($problems_info, $problems_details)=$problem_object->get_problems($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($problems_details!=-1){
				$tbl_data .= '<table id="table_problem" class="table table-hover b-t b-light m-b-none">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			for($i=0;$i<count($problems_details);$i++){
					$tbl_data.='<tbody>
								<tr><td><label class="checkbox m-n i-checks"><input type="radio" name="vis_problem_id" id="vis_problem_id" value="'.$problems_details[$i]['problem_id'].'" /><i></i></label></td>';
					$tbl_data.='<td>'.$problems_details[$i]['subject'].'</td><td>'.$problems_details[$i]['department_name'].'</td><td>'.$problems_details[$i]['status_name'].'</td></tr>';
			}
				$tbl_data.='</tbody></table><script type="application/javascript">$(document).ready(function() {$("#table_problem").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "100%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		if($tbl_data==''){
				$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
				$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
		}else{
			$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="'.count($problems_details).'">';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function attach_cmdb_problem($operation) {
        global $vis_language;
		$data=parse_form_array($operation['vis_action']); 
		if(!isset($data['vis_problem_id'])) {
            /*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPLEASESELECTCIITEM'].'"); </script>';*/
            return false;
        }
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
	    $database=new class_database();
        $problem_object=new class_problem($database);
		$ticket_object=new class_ticket($database);
		$filter1=VIS_TABLE_PREFIX.'ticket.ticket_id='.$data['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter1, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA); 
		$data['vis_attach_type']=1;
		$data['vis_parent_id']=$data['vis_ticket_id'];
		$data['vis_child_id']=$data['vis_problem_id'];
		$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$filter = " attach_type=1 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
		list($total_ci, $attached_problem)=$problem_object->get_attach_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_object->add_audit_log($ticket_details[0], 20, $attached_problem[0]['subject'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_service_cost_form").dialog("close"); </script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$data['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$data['vis_ticket_id'].", 'vis_department_id':".$data['vis_dept_id'].", 'vis_readonly':1});$('.modal').modal('toggle'); </script>";
		}
    }

	function confirm_delete_note($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETENOTE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'problem', 'vis_operation':'delete_note', 'vis_remark_id':".$operation['vis_remark_id'].", 'vis_problem_id':".$operation['vis_problem_id']."});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

    function delete_note($operation) {
        global $vis_language;
        $database = new class_database();
		
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object = new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $problems_details=$problems_details[0];
		
        $result = $problem_object->delete_note($operation['vis_remark_id'],6, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_details = $problem_object->get_note($problems_details['problem_id'], 3, 6, $problems_details['problem_from'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $note_count=count($note_details);
	   
        $database->database_disconnect();
        
		if($result) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			if($note_count==0)
			{
				echo '$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"problem", "vis_operation":"problems_details", "vis_problem_id":"'.$operation['vis_problem_id'].'"});</script>';
			}
			else
			{
				echo '$("#ticket_note_'.$operation['vis_remark_id'].'").remove();';
				echo 'if(!$("#ticket_details.active").length && $("[id^=\'ticket_note_\']:first").hasClass("m-t-sm")) $("[id^=\'ticket_note_\']:first").removeClass("m-t-sm");</script>';
			}
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        
        return $result;
    }
	function get_problem_properties($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$problems_details=$problems_details[0];
		$database->database_disconnect();
        $message_info['problem_id']=(isset($operation['vis_problem_id']) && is_numeric($operation['vis_problem_id']))?$operation['vis_problem_id']:0;
        $message_info['staff_id']=(isset($operation['vis_staff_id']) && is_numeric($operation['vis_staff_id']))?$operation['vis_staff_id']:0;
        include(VIS_PATH_TEMPLATE.'problem_staff_properties.php');
        return true;
    }
	
	function update_problem_staff_properties($operation) {
        $data=parse_form_array($operation['vis_action']);
		global $vis_language;
        if(isset($data['vis_email']) || trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		if(!isset($data['vis_subject']) || trim($data['vis_subject'])==''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQSUB'].'"); </script>';
            return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff_object = new class_staff($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$data['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($problems_details==-1) return false;
        $problems_details=$problems_details[0];
		$filter =' email="'.$data['vis_email'].'"';
        $staff=$staff_object->get_staff($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($staff==-1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEMAILMISS'].'"); </script>';
            return false;
        }
        else {
			$data['staff_id']=$staff[0]['staff_id'];
			$ret=$problem_object->update_problem_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
       
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(".modal").modal("toggle"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"problem", "vis_operation":"problems_details", "vis_problem_id":'.$data['vis_problem_id'].'});  $("#vis_details_list_'.$data['vis_problem_id'].'").visExecution("load_area",{"vis_module":"problem", "vis_operation":"get_details", "vis_problem_id":'.$data['vis_problem_id'].', "vis_action":"details"});set_active_tab("ticket_details"); </script>';
        return true;
    }
	
	function get_staff($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $object=new class_staff($database);
        $filter ='is_enabled=1 AND (first_name like "%'.$operation['vis_data'].'%" OR last_name like "%'.$operation['vis_data'].'%" OR email like "%'.$operation['vis_data'].'%" OR user_name like "%'.$operation['vis_data'].'%")';
        $staff=$object->get_staff($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $result='[';
        if($staff!=-1)
			for($i=0;$i<count($staff);$i++) {
				$result .='{"id":"'.$staff[$i]['staff_id'].'", "full_name":"'.str_replace("\'","'",trim($staff[$i]['first_name'])).' '.str_replace("\'","'",trim($staff[$i]['last_name'])).'","email":"'.trim($staff[$i]['email']).'"},';
			}
        $result=substr($result, 0, -1);
        if($result=='') return false;
        $result.=']';
		$database->database_disconnect();
		echo $result;
    }
	function problem_description_edit($operation){
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $problems_details=$problems_details[0];
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
        $problems_details['description'] = get_plain_text($problems_details['description']);
		}
        include(VIS_PATH_TEMPLATE.'problem_description_edit.php');
        return true;
    }
	function update_problem_description($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        if(!isset($data['vis_problem_desc']) || trim(strip_tags($data['vis_problem_desc'],"<img>")) == ''){
			if(VIS_LOCATION_AREA==0) echo $vis_language['MSGREQFLDDESC'];
            else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_problem_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_problem_desc']);
		$result=$problem_object->update_problem_description($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_ticket_post_content_text_'.$data['vis_problem_id'].'").show(); $("#vis_ticket_post_content_edit_'.$data['vis_problem_id'].'").hide(); $("#vis_ticket_post_content_text_'.$data['vis_problem_id'].'").html("'.$data['vis_problem_desc'].'"); </script>';
        return $result;
    }
	function problem_analysis_form($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $problems_details=$problems_details[0];$attachments=-1;
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR == 0) {  	
			$problems_details['rootcause']=get_plain_text($problems_details['rootcause']);
			$problems_details['impact_analysis']=get_plain_text($problems_details['impact_analysis']);
			$problems_details['symptoms']=get_plain_text($problems_details['symptoms']);
		}
		if($operation['vis_analysis_type']=='rootcause'){
			if($problems_details['rootcause_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($problems_details['rootcause_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_analysis_type']=='impact'){
			if($problems_details['impact_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($problems_details['impact_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_analysis_type']=='symptons'){
			if($problems_details['symptoms_attachment']!=''){ 
				$attachments=$problem_object->get_problem_attachment($problems_details['symptoms_attachment'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'problem_analysis_update.php');
        return true;
    }
	function update_problem_analysis($operation) {
        global $vis_language;
		
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_problem_impact_desc']) || trim(strip_tags($data['vis_problem_impact_desc'],"<img>"))==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_problem_impact_desc'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_problem_impact_desc']);
		$data['analysis_type'] = $operation['vis_analysis_type'];
		$result=$problem_object->update_problem_analysis($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$result)
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        else {
			echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_problem_analysis_show_".$data['vis_problem_id']."').visExecution('load_area',{'vis_module':'problem', 'vis_operation':'get_details','vis_action': 'analysis', 'vis_analysis_type': '".$data['analysis_type']."', 'vis_problem_id':".$data['vis_problem_id']."});</script>";
		}
        return $result;
    }
	function confirm_delete_analysis($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'problem', 'vis_operation':'delete_analysis', 'vis_problem_id':".$operation['vis_problem_id'].", 'vis_analysis_type':'".$operation['vis_analysis_type']."'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_analysis($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $result = $problem_object->delete_analysis($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_problem_analysis_show_".$operation['vis_problem_id']."').visExecution('load_area',{'vis_module':'problem', 'vis_operation':'get_details','vis_action': 'analysis', 'vis_analysis_type': '".$operation['vis_analysis_type']."', 'vis_problem_id':".$operation['vis_problem_id']."});</script>";
			
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	
	function problem_solution_form($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'selfhelp.php');
        $selfhelp_object=new class_selfhelp($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $problems_details=$problems_details[0];
		if($operation['vis_solution_type']=='permanent'){	
			if($problems_details['permanent_id']!=''){	
				$filter='article_id='.$problems_details['permanent_id'];
				list($categories_info, $selfhelp_data)=$selfhelp_object->get_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_solution_type']=='workaround'){
			if($problems_details['workaround_id']!=''){		
				$filter='article_id='.$problems_details['workaround_id'];
				list($categories_info, $selfhelp_data)=$selfhelp_object->get_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
        $selfhelp_data[0]['content'] = get_plain_text($selfhelp_data[0]['content']);
		}
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'problem_solution_update.php');
        return true;
    }
	function update_problem_solution($operation){
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'selfhelp.php');
        $selfhelp_object=new class_selfhelp($database);
		$data=parse_form_array($operation['vis_action']);
		$data1 =array();
		if(!isset($data['vis_title']) || trim($data['vis_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDTIT'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_description']) || trim(strip_tags($data['vis_description'],"<img>"))==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDDESC'].'"); </script>';
            return false;
        }
		if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
		$data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		
		$filter = " parent_id=0 AND display_status=2 AND is_enabled=1 AND solution_id=1 AND domain_id=".$operation['vis_domain']; // check root category is available or not
		list($root_info, $root_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($root_info['total']==0){
			$last_inserted_id  =$problem_object->add_selfhelp_category(array('vis_parent'=>'0', 'vis_title'=>$vis_language['TXTPROBLEMSOLUTION'], 'vis_description'=>'', 'vis_solution'=>'1', 'vis_domain'=>$operation['vis_domain']), VIS_STAFF_ID, VIS_LOCATION_AREA);
			
		}else{
			$last_inserted_id = $root_category[0]['selfhelp_id'];
		}
		if($operation['vis_solution_type']=='permanent'){
			$filter = " parent_id=".$last_inserted_id." AND display_status=2 AND is_enabled=1 AND solution_id=2 AND domain_id=".$operation['vis_domain']; // check permanent solution category is available or not
			list($permanent_info, $permanent_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($permanent_info['total']==0){
				$permanent_category=array();
				$data1['vis_parent']=$last_inserted_id;
				$data1['vis_title']=$vis_language['TXTPERMANANT'];
				$data1['vis_description']='';
				$data1['vis_solution']=2;
				$data1['vis_domain']=$operation['vis_domain'];
				
				$permanent_category[0]['selfhelp_id']=$problem_object->add_selfhelp_category($data1, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if($operation['vis_solution_type']=='workaround'){
			$filter = " parent_id=".$last_inserted_id." AND display_status=2 AND is_enabled=1 AND solution_id=3 AND domain_id=".$operation['vis_domain']; // check workaround solution category is available or not
			list($workaround_info, $workaround_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($workaround_info['total']==0){
				$workaround_category=array();
				$data1['vis_parent']=$last_inserted_id;
				$data1['vis_title']=$vis_language['TXTWORKAROUND'];
				$data1['vis_description']='';
				$data1['vis_solution']=3;
				$data1['vis_domain']=$operation['vis_domain'];
				$workaround_category[0]['selfhelp_id']=$problem_object->add_selfhelp_category($data1, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		$data['vis_domain']=$operation['vis_domain'];
		if($data['vis_selfhelp_id']==''){
			
			$data['vis_article_title'] = preg_replace('/\s+/', ' ',trim($data['vis_title']));
			$data['vis_article_content']=$data['vis_description'];
			$data['vis_article_comment']=0;
			$data['vis_article_rating']=0;
			$data['vis_article_stick']=0;
			$data['vis_article_attach']=0;
			$data['vis_article_login']=0;
			$data['vis_article_subscribe']=0;
			$data['vis_article_url'] = str_replace(array('"', "'", '/', '\\'), '',$data['vis_title']); 
			$data['vis_article_url'] = str_replace(' ', '-',$data['vis_article_url']); 
			$data['vis_status']='on';
			$data['vis_category_id']=($operation['vis_solution_type']=='permanent') ? $permanent_category[0]['selfhelp_id']: $workaround_category[0]['selfhelp_id'];
			$data['vis_language']=1; // set deafult article language english
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'selfhelp.php');
			$object=new class_selfhelp($database);
			$ret=$object->add_article($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				
			$set=$problem_object->update_selfhelp_problem($data['vis_problem_id'], $ret,$operation['vis_solution_type'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else{
			$ret=$problem_object->update_selfhelp_article($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		if(!$ret){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}else{
			echo "<script> $('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."'); $('#problem_analysis_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'solution', 'vis_problem_id':'".$data['vis_problem_id']."', 'vis_department_id':'".$data['vis_department_id']."', 'vis_readonly':1});</script>";
			return true;
		}
	}
	function confirm_delete_solution($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'problem', 'vis_operation':'delete_solution', 'vis_problem_id':".$operation['vis_problem_id'].", 'vis_solution_type':'".$operation['vis_solution_type']."', 'vis_solution_id':'".$operation['vis_solution_id']."'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_solution($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
        $result = $problem_object->delete_solution($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			echo "<script> $('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."'); $('#problem_analysis_".$operation['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'solution', 'vis_problem_id':'".$operation['vis_problem_id']."', 'vis_readonly':1});</script>";
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	function link_solution($operation) {
        global $vis_language;
		include(VIS_PATH_TEMPLATE.'link_solution.php');
        return true;
    }
	function get_problem_solution($operation){
		global $vis_language;
		
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'selfhelp.php');
        $selfhelp_object=new class_selfhelp($database);
		$search_category=-1;
		$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_problem_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$problems_details=$problems_details[0];
		
		$filter = " parent_id=0 AND display_status=2 AND is_enabled=1 AND solution_id=1 AND domain_id=".$problems_details['domain_id'];
		list($root_info, $root_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        if($operation['vis_solution_type']=='permanent'){
			$filter = " parent_id=".$root_category[0]['selfhelp_id']." AND display_status=2 AND is_enabled=1 AND solution_id=2 AND domain_id=".$problems_details['domain_id']; // check permanent solution category is available or not
			list($permanent_info, $permanent_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($permanent_category!=-1){
				
				$filter = " parent_id=".$permanent_category[0]['selfhelp_id']." AND article_title like '%".$operation['vis_filter']."%' ";
				$search_category=$problem_object->get_selfhelp_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		
		if($operation['vis_solution_type']=='workaround'){
			$filter = " parent_id=".$root_category[0]['selfhelp_id']." AND display_status=2 AND is_enabled=1 AND solution_id=3 AND domain_id=".$problems_details['domain_id']; // check workaround solution category is available or not
			list($workaround_info, $workaround_category)=$selfhelp_object->get_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($workaround_category!=-1){
				$filter = " parent_id=".$workaround_category[0]['selfhelp_id']." AND article_title like '%".$operation['vis_filter']."%' ";
				$search_category=$problem_object->get_selfhelp_article($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		
		$tbl_data='';
		if($search_category!=-1){
			
			for($i=0;$i<count($search_category);$i++){
			    $tbl_data.='<label class="radio m-n i-checks"><input type="radio" name="vis_solution_id" id="vis_solution_id" value="'.$search_category[$i]['article_id'].'" /><i></i>';
				$tbl_data.=$search_category[$i]['article_title'].'</label>';
			}
		
		}
		
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div><input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
		}else{
			$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="'.count($search_category).'">';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function link_problem_solution($operation){
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		$data=parse_form_array($operation['vis_action']);
		
		if(!isset($data['vis_solution_id']) || trim($data['vis_solution_id'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		
		$ret=$problem_object->update_selfhelp_problem($data['vis_problem_id'], $data['vis_solution_id'],$data['vis_solution_type'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(!$ret){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
			return false;
		}else{
			echo "<script> $('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."'); $('#problem_analysis_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'solution', 'vis_problem_id':'".$data['vis_problem_id']."'});$('.modal').modal('toggle');</script>";
			return true;
		}
	}
	function attach_problem_ci($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
		if(isset($operation['vis_attach_ci']) && $operation['vis_attach_ci']=='success'){
			$data=parse_form_array($operation['vis_action']);
			$flag=0;
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=4;
				$data['vis_parent_id']=$data['vis_problem_id'];
				$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$data['vis_problem_id'];
				list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$flag=1;
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=4 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$problem_object->add_audit_log($problems_details[0], 16, $attached_ci[0]['name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='problem'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$data['vis_problem_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$department_id=0;
			if(isset($operation['vis_department'])) $department_id=$operation['vis_department'];
			$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
			$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);			
			//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'problem_attach_ci.php');
		}
        return true;
	}
	function change_cofiguration($operation){
		global $vis_language;
		$filter = '';
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $cmdb_object=new class_cmdb($database);
		$setting_object=new class_setting($database);
		
		$filter .= VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'].' AND ';
		
        if(isset($operation['vis_configuration_id']) && $operation['vis_configuration_id']!='0' && $operation['vis_configuration_id']!=''){
			$filter .= ' ci_type_id='.$operation['vis_configuration_id']." and ";
		}
		
		if($operation['attached_id']!=""){
			$selected_ci=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_ci)-1;$i++){
				$filter .= ' assets_id!='.$selected_ci[$i]." and ";
			}
		}
		$filter=substr($filter, 0, -4);
		
		if(isset($operation['vis_filter']) && $operation['vis_filter']!=''){
			if($filter!=''){$filter .= ' AND ';}
			$filter .= VIS_TABLE_PREFIX."itil_cmdb_assets.name like '%".$operation['vis_filter']."%'";
		}
	    $assets_details=$cmdb_object->get_assets($filter,'50', '','',VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($assets_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTITEMNAME'].'</th>
										<th>'.$vis_language['TXTCITYPE'].'</th>
										<th>'.$vis_language['TXTUSEDBY'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($assets_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$assets_details[$i]['assets_id'].'" /><i></i></label></td>';
				$confi_item_details=$setting_object->get_configuration_item_category($assets_details[$i]['ci_type_id'],'is_enabled=1');
				$tbl_data.='<td>'.$assets_details[$i]['name'].'</td><td>'.$confi_item_details[0]['name'].'</td><td>'.$assets_details[$i]['usedby'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="0">';
		}else{
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="'.count($assets_details).'">';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function confirm_detach_ci($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDETACH'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'problem', 'vis_operation':'detach_ci', 'vis_attach_type':'".$operation['vis_attach_type']."', 'vis_detach_for':'".$operation['vis_detach_for']."', 'vis_child_id':".$operation['vis_child_id'].", 'vis_parent_id':".$operation['vis_parent_id']."});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function detach_ci($operation) {
        global $vis_language;
		$database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
        $result = $problem_object->detach_ci($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($result) {
			if($operation['vis_detach_for']=='problem'){
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_parent_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$operation['vis_parent_id']."' }); set_active_tab('ticket_details');</script>";
			}
			if($operation['vis_detach_for']=='problem_ticket'){
				
				$filter = " attach_type=1 AND child_id=".$operation['vis_child_id']." AND parent_id=".$operation['vis_parent_id'];
						list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_child_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$operation['vis_child_id']."' }); $('#repldiv').html('<a id=\"vis_prob\" href=\"javascript:void(0);\" onclick=\"check_link_ticket_exist(".$total_ticket.");\">".$vis_language['TXTREPLYALLLINKEDTICKET']."</a>');set_active_tab('ticket_details');</script>";
			}

			if($operation['vis_detach_for']=='changes_ticket'){
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_child_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$operation['vis_child_id']."' }); set_active_tab('ticket_details');</script>";
			}
			if($operation['vis_detach_for']=='changes'){
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_parent_id']."').visExecution('load_operations',{'vis_module':'changes', 'vis_operation':'get_details', 'vis_action':'details', 'vis_changes_id':'".$operation['vis_parent_id']."' }); set_active_tab('ticket_details');</script>";
			}

			if($operation['vis_detach_for']=='release'){
				echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$operation['vis_child_id']."').visExecution('load_operations',{'vis_module':'releases', 'vis_operation':'get_details', 'vis_action':'details', 'vis_release_id':'".$operation['vis_child_id']."' }); set_active_tab('release_details');</script>";
			}
		}
		else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        return $result;
    }
	function attach_ticket_to_problem($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
		if(isset($operation['vis_attach_ticket']) && $operation['vis_attach_ticket']=='success'){
			$data=parse_form_array($operation['vis_action']);
			
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=1;
				$data['vis_child_id']=$data['vis_problem_id'];
				$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$data['vis_problem_id'];
				list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_parent_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=1 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_ticket, $attached_ticket)=$problem_object->get_ticket_attached_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$problem_object->add_audit_log($problems_details[0], 15, $attached_ticket[0]['ticket_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='problem'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$data['vis_problem_id']."' }); $('#repldiv').html('<a id=\"vis_prob\" href=\"javascript:void(0);\" onclick=\"check_link_ticket_exist(".$total_ticket.");\">".$vis_language['TXTREPLYALLLINKEDTICKET']."</a>');set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'problem_attached_ticket.php');
		}
        return true;
	}
	function get_ticket_list($operation){
		global $vis_language;
		$filter = '';
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		
		$filter .= ' '.VIS_TABLE_PREFIX.'ticket.domain_id='.$operation['vis_domain_id']." AND ";		
        
		if($operation['attached_id']!=""){
			$selected_ci=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_ci)-1;$i++){
				$filter .= ' '.VIS_TABLE_PREFIX.'ticket.ticket_id!='.$selected_ci[$i]." and ";
			}
		}
		$filter=substr($filter, 0, -4);
		if(isset($operation['vis_filter']) && $operation['vis_filter']!=''){
			if($filter!=''){$filter .= ' AND ';}
			$filter .= VIS_TABLE_PREFIX."ticket.subject like '%".$operation['vis_filter']."%'";
		}
	    list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        $tbl_data='';
		if($ticket_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_ticket_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($ticket_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$ticket_details[$i]['ticket_id'].'" /><i></i></label></td>';
				
				$tbl_data.='<td>'.$ticket_details[$i]['subject'].'</td><td>'.$ticket_details[0]['department_name'].'</td><td>'.$ticket_details[$i]['ticket_status'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="0">';
		}else{
			$tbl_data .='</table><input type="hidden" name="total_attach_count" id="total_attach_count" value="'.count($ticket_details).'">';
			$tbl_data .= '<script type="application/javascript">$(document).ready(function() {$("#table_ticket_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "100%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	function attach_changes_to_problem($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
		if(isset($operation['vis_attach_changes']) && $operation['vis_attach_changes']=='success'){
			$data=parse_form_array($operation['vis_action']);
			if(isset($data['vis_attach_id'])){
				$data1['vis_attach_type']=2;
				$data1['vis_parent_id']=$data['vis_problem_id'];
				$data1['vis_child_id']=$data['vis_attach_id'];
				$ret=$problem_object->add_itil_relation($data1,VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$data['vis_problem_id'];
				list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				$filter = " attach_type=2 AND child_id=".$data1['vis_child_id']." AND parent_id=".$data1['vis_parent_id'];
				list($total_changes, $attached_changes)=$problem_object->get_changes_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				$problem_object->add_audit_log($problems_details[0], 17, $attached_changes[0]['changes_name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
						
				if($ret){
					if($operation['ci_for']=='problem'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$data['vis_problem_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'problem_attached_changes.php');
		}
        return true;
	}
	
	function get_changes_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
        $filter = '';
		$filter .= VIS_TABLE_PREFIX.'itil_changes.domain_id='.$operation['vis_domain_id'];
		
		if(isset($operation['vis_filter']) && $operation['vis_filter']!=''){
			if($filter!=''){$filter .= ' AND ';}
			$filter .= VIS_TABLE_PREFIX."itil_changes.subject like '%".addslashes($operation['vis_filter'])."%' or ".VIS_TABLE_PREFIX."itil_changes.changes_hash like '%".addslashes($operation['vis_filter'])."%'";
		}
	    list($changes_info, $changes_details)=$changes_object->get_changes($filter, '50', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($changes_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_ticket_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTNAME'].'</th>
										<th>'.$vis_language['TXTDEPARTMENT'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($changes_details);$i++){
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="radio m-n i-checks"><input type="radio" name="vis_attach_id" id="vis_attach_id" value="'.$changes_details[$i]['changes_id'].'" /><i></i></label></td>';
				
				$tbl_data.='<td>'.$changes_details[$i]['subject'].'</td><td>'.$changes_details[0]['department_name'].'</td><td>'.$changes_details[$i]['status_name'].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
		}else{
			$tbl_data .= '</table><script type="application/javascript">$(document).ready(function() {$("#table_ticket_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "90%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	
	function attach_task_to_problem($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		
		if(isset($operation['vis_attach_task']) && $operation['vis_attach_task']=='success'){
			$data=parse_form_array($operation['vis_action']);
			
			if($data['total_attach_count']>0){
				$data['vis_attach_type']=8;
				$data['vis_parent_id']=$data['vis_problem_id'];
				$filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$data['vis_problem_id'];
				list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				for($i=0;$i<$data['total_attach_count'];$i++){
					
					if(isset($data['vis_attach_id_'.$i])){
						$data['vis_child_id']=$data['vis_attach_id_'.$i];
						$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						
						$filter = " attach_type=8 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_parent_id'];
						list($total_task, $attached_task)=$problem_object->get_task_attachedto_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						$problem_object->add_audit_log($problems_details[0], 18, $attached_task[0]['task_title'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
					}
				}
				if($ret){
					if($operation['ci_for']=='problem'){ 
						echo "<script>$('#vis_global_msg_div').visInterface('load_global_message', '".$vis_language['MSGSUCCOPRT']."');$('#vis_details_list_".$data['vis_problem_id']."').visExecution('load_operations',{'vis_module':'problem', 'vis_operation':'get_details', 'vis_action':'details', 'vis_problem_id':'".$data['vis_problem_id']."' }); set_active_tab('ticket_details');$('.modal').modal('toggle');</script>";
					}
				}
			}
		}
		else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
			$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'problem_attached_task.php');
		}
        return true;
	}
	function get_task_list($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		if(VIS_TASK_VIEW_ACCESS==0)
		{
			echo json_encode(array('vis_msg' => $vis_language['MSGACCSSDND']));
			return false;
		}
        $filter = VIS_TABLE_PREFIX.'task.autotask_flag=0 and '.VIS_TABLE_PREFIX.'task.task_status!=4  and ('.VIS_TABLE_PREFIX.'task.staff_id='.VIS_STAFF_ID.' OR '.VIS_TABLE_PREFIX.'task_assign.owner_id='.VIS_STAFF_ID.') AND ';


		if($operation['attached_id']!=""){
			$selected_ci=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_ci)-1;$i++){
				$filter .= VIS_TABLE_PREFIX.'task.task_id!='.$selected_ci[$i].' AND ';
			}
		} 
		$filter=substr($filter, 0, -4);		
		
		if(isset($operation['vis_filter']) && trim($operation['vis_filter'])!=''){
			$filter .= " AND ".VIS_TABLE_PREFIX."task.task_title like '%".$operation['vis_filter']."%'";
		}
		$filter .= " GROUP BY ".VIS_TABLE_PREFIX."task.task_id LIMIT 50";
		list($task_info, $task_details)=$problem_object->get_task_list($filter,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
        $status=array(1 => $vis_language['TXTINPROGRESS'],2 => $vis_language['TXTOVERDUE'],3 => $vis_language['TXTCOMPLETED'],4 => $vis_language['TXTCANCELED'],5 =>$vis_language['TXTNOTSTARTED']);
		if($task_details!=-1){
			$tbl_data .= '<table class="table table-hover b-t b-light m-b-none" id="table_ticket_relation">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTTITLE'].'</th>
										<th>'.$vis_language['TXTSTATUS'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($task_details);$i++){
				if($task_details[$i]['enddate_diff']<=0){ 
					if($task_details[$i]['task_status']!=3 && $task_details[$i]['task_status']!=4){
						$task_details[$i]['task_status'] = 2;
					}
				}
				$tbl_data.='<tr>';
				$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$task_details[$i]['task_id'].'" /><i></i></label></td>';
				$tbl_data.='<td>'.$task_details[$i]['task_title'].'</td><td>'.$status[$task_details[$i]['task_status']].'</td></tr>';
			}
		}
		if($tbl_data==''){
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_attach_count" id="total_attach_count" value="0">';
		}else{
			$tbl_data .='</table><input type="hidden" name="total_attach_count" id="total_attach_count" value="'.count($task_details).'">';
			$tbl_data .= '<script type="application/javascript">$(document).ready(function() {$("#table_ticket_relation").dataTable({ "sScrollY":  ( 0.6 * $(window).height() ),"bPaginate": false, "bJQueryUI": true, "bScrollCollapse": true, "bAutoWidth": "100%", "scrollX": true, "sScrollXInner": "100%","bFilter": false,"bInfo": false,"ordering": false});});</script>';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	
	function load_inline_images($operation) {
		global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object = new class_problem($database);
        $filter=VIS_TABLE_PREFIX.'itil_problems.problem_id='.$operation['vis_post_id'];
        list($problems_info, $problems_details)=$problem_object->get_problems($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($operation['vis_type']=='desc')
			$content=stripslashes($problems_details[0]['description']);
		elseif($operation['vis_type']=='rootcause')
			$content=stripslashes($problems_details[0]['rootcause']);
		elseif($operation['vis_type']=='impact')
			$content=stripslashes($problems_details[0]['impact_analysis']);
		elseif($operation['vis_type']=='symptons')
			$content=stripslashes($problems_details[0]['symptoms']);
			
        if($operation['vis_display'])
			echo json_encode( array('vis_post_content_html' => $content) );
        else  
			echo json_encode( array('vis_post_content_html' => preg_replace("/<img[^>]+\>/i", " ", $content)) );
		
        $database->database_disconnect();
	}
	function get_impact_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or department_access in ('.$vis_department_id.'))';
		$impact=$ticket_module->get_properties('get_impacts', '', $filter_condtn);	
		$database->database_disconnect();
		if($impact!='')
        echo get_xml($impact, 'impact');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
}
?>
